/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.renderer.text;

import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.Extension;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.internal.renderer.NodeRendererMap;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.node.Node;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.renderer.NodeRenderer;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.renderer.Renderer;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.renderer.text.CoreTextContentNodeRenderer;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.renderer.text.TextContentNodeRendererContext;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.renderer.text.TextContentNodeRendererFactory;
import club.sk1er.mods.scrollabletooltips.elementa.impl.commonmark.renderer.text.TextContentWriter;
import java.util.ArrayList;
import java.util.List;

public class TextContentRenderer
implements Renderer {
    private final boolean stripNewlines;
    private final List<TextContentNodeRendererFactory> nodeRendererFactories;

    private TextContentRenderer(Builder builder) {
        this.stripNewlines = builder.stripNewlines;
        this.nodeRendererFactories = new ArrayList<TextContentNodeRendererFactory>(builder.nodeRendererFactories.size() + 1);
        this.nodeRendererFactories.addAll(builder.nodeRendererFactories);
        this.nodeRendererFactories.add(new TextContentNodeRendererFactory(){

            @Override
            public NodeRenderer create(TextContentNodeRendererContext context) {
                return new CoreTextContentNodeRenderer(context);
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void render(Node node2, Appendable output) {
        RendererContext context = new RendererContext(new TextContentWriter(output));
        context.render(node2);
    }

    @Override
    public String render(Node node2) {
        StringBuilder sb = new StringBuilder();
        this.render(node2, sb);
        return sb.toString();
    }

    private class RendererContext
    implements TextContentNodeRendererContext {
        private final TextContentWriter textContentWriter;
        private final NodeRendererMap nodeRendererMap = new NodeRendererMap();

        private RendererContext(TextContentWriter textContentWriter) {
            this.textContentWriter = textContentWriter;
            for (int i2 = TextContentRenderer.this.nodeRendererFactories.size() - 1; i2 >= 0; --i2) {
                TextContentNodeRendererFactory nodeRendererFactory = (TextContentNodeRendererFactory)TextContentRenderer.this.nodeRendererFactories.get(i2);
                NodeRenderer nodeRenderer = nodeRendererFactory.create(this);
                this.nodeRendererMap.add(nodeRenderer);
            }
        }

        @Override
        public boolean stripNewlines() {
            return TextContentRenderer.this.stripNewlines;
        }

        @Override
        public TextContentWriter getWriter() {
            return this.textContentWriter;
        }

        @Override
        public void render(Node node2) {
            this.nodeRendererMap.render(node2);
        }
    }

    public static interface TextContentRendererExtension
    extends Extension {
        public void extend(Builder var1);
    }

    public static class Builder {
        private boolean stripNewlines = false;
        private List<TextContentNodeRendererFactory> nodeRendererFactories = new ArrayList<TextContentNodeRendererFactory>();

        public TextContentRenderer build() {
            return new TextContentRenderer(this);
        }

        public Builder stripNewlines(boolean stripNewlines) {
            this.stripNewlines = stripNewlines;
            return this;
        }

        public Builder nodeRendererFactory(TextContentNodeRendererFactory nodeRendererFactory) {
            this.nodeRendererFactories.add(nodeRendererFactory);
            return this;
        }

        public Builder extensions(Iterable<? extends Extension> extensions) {
            for (Extension extension : extensions) {
                if (!(extension instanceof TextContentRendererExtension)) continue;
                TextContentRendererExtension textContentRendererExtension = (TextContentRendererExtension)extension;
                textContentRendererExtension.extend(this);
            }
            return this;
        }
    }
}

